const express = require('express');
const {
    homePage,
    getNotice,
    getTeacher,
    getCommitte,
    getInstructor,
    getClassRoutine,
    getExamRoutine,
    getPhotoGallery
} = require('../controller/web');

const router = express.Router();

// Home page
router.get('/home', homePage);

// Page routes
router.get('/notices', getNotice);
router.get('/gallery', getPhotoGallery);
router.get('/teachers', getTeacher);
router.get('/committee', getCommitte);
router.get('/instructors', getInstructor);
router.get('/class-routine', getClassRoutine);
router.get('/exam-routine', getExamRoutine);

module.exports = router;
