const express = require('express')
const { login, authdata, summarydata, returnyear, returnmonth } = require('../controller/student-auth')
const studentAuthMiddelware = require('../middleware/student-auth')

const router = express.Router()

// auth
router.route('/').get(studentAuthMiddelware, authdata)
router.route('/login').post(login)
// dashboard summary data.
router.route('/summary').get(studentAuthMiddelware, summarydata)
// report section route
router.route('/returnyear/:year').get(studentAuthMiddelware, returnyear)
router.route('/returnmonth/:year').get(studentAuthMiddelware, returnmonth)

module.exports = router