const express = require('express')
const { create, upload, routine, update, deleted, hsc_routine, hons_routine, degree_routine } = require('../controller/routine');
const adminauthMiddleware = require('../middleware/admin_auth_validator');

const router = express.Router()

// get notice with admin.
router.route('/').get(routine)
// allocated
router.route('/hsc').get(hsc_routine)
router.route('/hons').get(hons_routine)
router.route('/degree').get(degree_routine)

// get notice with anyone

// get notice with student of classes.

// create notice.
router.route("/create").post(upload.single("attachment"), create);
// update
router.route("/update").post(upload.single("attachment"), update);
// delete
router.route('/delete/:id').delete(deleted)

module.exports = router
 