const express = require('express')
const { initPayment, listofPayment, deletePayment, updatePayment, selectPayment, paymentReports, reportwithPaymentId } = require('../controller/payment')

const router = express.Router()

// define route
router.route('/').get(listofPayment)
router.route('/reports/:id/:payment_for').get(reportwithPaymentId)
router.route('/select').get(selectPayment)
router.route('/create').post(initPayment)
router.route('/update').post(updatePayment)
router.route('/delete/:id').delete(deletePayment)
// reports
router.route('/reports/:payment_id/:payment_for').get(paymentReports)

module.exports = router