const express = require('express')
const { findreports, save, attandancedata, summarydata, studentdata, authontication, details, reportstudents, reportstudent, currentmonth, returnyear, returnmonth, searchreport, studentreport, returndate, homescreen } = require('../controller/attandance')
const adminauthMiddleware = require('../middleware/admin_auth_validator')
const attandanceMiddleware = require('../middleware/attandance')


const router = express.Router()
// auth this.
router.route('/auth').post(authontication)
// details
router.route('/details').get(adminauthMiddleware, details) // required token
router.route('/homescreen').get(adminauthMiddleware, homescreen) // required token
// Admin search
router.route('/search/:classn/:section/:department/:from/:to').get(searchreport)
router.route('/search/singlereport/:id/:from/:to').get(studentreport)


// Admin search

// get attandance data
router.route('/data/:classn/:section/:department').get(attandancedata) // params using.
// get students data.
router.route('/student/:classn/:section/:department').get(studentdata)
//get summary info in dashboard screen.
router.route('/data/summary/:classn/:section/:department').get(summarydata)
// report this.
// class based many report.
router.route('/reports/:classn/:section/:department/:from/:to').get(reportstudents)
// student base many report.
router.route('/report/:studentid/:from/:to').get(reportstudent)
// monthly report.
router.route('/reports/currentmonth').get(currentmonth)
// year
router.route('/year/:classid/:sectionid/:departmentid/:year').get(returnyear)
// month
router.route('/month/:classid/:sectionid/:departmentid/:date').get(returnmonth)
// date
router.route('/date/:classid/:sectionid/:departmentid/:date').get(returndate)

// store all primary data in local storage.
// if connection is false, then call main context state. then disabled all query.
// create separate component in connection checker.
// system

// report
router.route('/findreports').post(findreports)

// add record
router.route('/save').post(attandanceMiddleware, save)


module.exports = router