const express = require('express')
const { login, register, details, gets, deleteadmin, updateadminprofile, updateadminpassword, dashboard } = require('../controller/admin')
const adminauthMiddleware = require('../middleware/admin_auth_validator')
// middleware.
const router = express.Router()

router.route('/').get(adminauthMiddleware, gets)
// update admin
router.route('/updateprofile').post(adminauthMiddleware, updateadminprofile) // required token
router.route('/updatepassword').post(adminauthMiddleware, updateadminpassword) // required token
// admin auth
router.route('/login').post(login)
router.route('/details').get(adminauthMiddleware, details) // required token
// dashboard
router.route('/dashboard').get(adminauthMiddleware, dashboard) 
// access list
router.route('/register').post(register)
// update and delete.
router.route('/delete/:uid').delete(adminauthMiddleware, deleteadmin)

module.exports = router